/// ONLINE
// %arg0: The ID of the game
// %arg1: The server
// %arg2: The TCP port
// %arg3: The UDP port
// %arg4: The game name
// %arg5: The version
@connected = false;
@buffer = buffer_create();
@selfID = "";
@name = "";
@selfGameID = "%arg0";
@server = "%arg1";
@version = "%arg5";
@race = false;
@vis = 0;
@save_enabled = 1;
if file_exists("@server.txt") {
	@file = file_text_open_read("@server.txt");
	@line = file_text_read_string(@file);
	file_text_close(@file);
	if @line != "" {
		@server = @line;
	}
}
#if TEMPFILE
	if(file_exists("tempOnline")){
		#if not GMNET
			buffer_read_from_file(@buffer, "tempOnline");
			@socket = buffer_read_uint16(@buffer);
			@udpsocket = buffer_read_uint16(@buffer);
			@selfID = buffer_read_string(@buffer);
			@name = buffer_read_string(@buffer);
			@selfGameID = buffer_read_string(@buffer);
			@race = buffer_read_uint8(@buffer);
			@n = buffer_read_uint16(@buffer);
			@vis = buffer_read_uint16(@buffer);
			@save_enabled = buffer_read_uint16(@buffer);
			for(@i = 0; @i < @n; @i += 1){
				@oPlayer = instance_create(0, 0, @onlinePlayer);
				@oPlayer.@ID = buffer_read_string(@buffer);
				@oPlayer.x = buffer_read_int32(@buffer);
				@oPlayer.y = buffer_read_int32(@buffer);
				@oPlayer.sprite_index = buffer_read_int32(@buffer);
				@oPlayer.image_speed = buffer_read_float32(@buffer);
				@oPlayer.image_xscale = buffer_read_float32(@buffer);
				@oPlayer.image_yscale = buffer_read_float32(@buffer);
				@oPlayer.image_angle = buffer_read_float32(@buffer);
				@oPlayer.@oRoom = buffer_read_uint16(@buffer);
				@oPlayer.@name = buffer_read_string(@buffer);
			}
		#endif
		#if GMNET
			buffer_load(@buffer, "tempOnline");
			@socket = buffer_read_u16(@buffer);
			@udpsocket = buffer_read_u16(@buffer);
			@selfID = buffer_read_string(@buffer);
			@name = buffer_read_string(@buffer);
			@selfGameID = buffer_read_string(@buffer);
			@race = buffer_read_u8(@buffer);
			@n = buffer_read_u16(@buffer);
			@vis = buffer_read_u16(@buffer);
			@save_enabled = buffer_read_u16(@buffer);
			for(@i = 0; @i < @n; @i += 1){
				@oPlayer = instance_create(0, 0, @onlinePlayer);
				@oPlayer.@ID = buffer_read_string(@buffer);
				@oPlayer.x = buffer_read_i32(@buffer);
				@oPlayer.y = buffer_read_i32(@buffer);
				@oPlayer.sprite_index = buffer_read_i32(@buffer);
				@oPlayer.image_speed = buffer_read_float(@buffer);
				@oPlayer.image_xscale = buffer_read_float(@buffer);
				@oPlayer.image_yscale = buffer_read_float(@buffer);
				@oPlayer.image_angle = buffer_read_float(@buffer);
				@oPlayer.@oRoom = buffer_read_u16(@buffer);
				@oPlayer.@name = buffer_read_string(@buffer);
			}
		#endif
	}else{
#endif
	@socket = socket_create();
	socket_connect(@socket, @server, %arg2);
	#if STUDIO
		@name = get_string("Enter your name:", "");
	#endif
	#if not STUDIO
		@name = wd_input_box("Name", "Enter your name:", "");
	#endif
	if(@name == ""){
		@name = "Anonymous";
	}
	@name = string_replace_all(@name, "#", "\#");
	if(string_length(@name) > 20){
		@name = string_copy(@name, 0, 20);
	}
	#if STUDIO
		@password = get_string("Enter a password:", "");
	#endif
	#if not STUDIO
		@password = wd_input_box("Password", "Leave it empty for no password:", "");
	#endif
	if(string_length(@password) > 20){
		@password = string_copy(@password, 0, 20);
	}
	@selfGameID += @password;
	#if STUDIO
		@race = show_question("Do you want to enable RACE mod? (shared saves will be disabled)");
	#endif
	#if not STUDIO
		wd_message_set_text("Do you want to enable RACE mod? (shared saves will be disabled)");
		@race = wd_message_show(wd_mk_information, wd_mb_yes, wd_mb_no, 0) == wd_mb_yes;
	#endif
	buffer_clear(@buffer);
	#if not GMNET
		buffer_write_uint8(@buffer, 3);
		buffer_write_string(@buffer, @name);
		buffer_write_string(@buffer, @selfGameID);
		buffer_write_string(@buffer, "%arg4");
		buffer_write_string(@buffer, @version);
		buffer_write_uint8(@buffer, @password != "");
		socket_write_message(@socket, @buffer);
		@udpsocket = udpsocket_create();
		udpsocket_start(@udpsocket, false, 0);
		udpsocket_set_destination(@udpsocket, @server, %arg3);
		buffer_clear(@buffer);
		buffer_write_uint8(@buffer, 0);
	#endif
	#if GMNET
		buffer_write_u8(@buffer, 3);
		buffer_write_string(@buffer, @name);
		buffer_write_string(@buffer, @selfGameID);
		buffer_write_string(@buffer, "%arg4");
		buffer_write_string(@buffer, @version);
		buffer_write_u8(@buffer, @password != "");
		socket_write_message(@socket, @buffer);
		@udpsocket = udpsocket_create();
		udpsocket_start(@udpsocket, false, 0);
		udpsocket_set_destination(@udpsocket, @server, %arg3);
		buffer_clear(@buffer);
		buffer_write_u8(@buffer, 0);
	#endif
	udpsocket_send(@udpsocket, @buffer);
#if TEMPFILE
	}
#endif
@pExists = false;
@pX = 0;
@pY = 0;
@t = 0;
@heartbeat = 0;
@stoppedFrames = 0;
@sGravity = 0;
@sX = 0;
@sY = 0;
@sRoom = 0;
@sSaved = false;
#if GMSND
sound_add_included("__ONLINE_sndChatbox.wav", 0, 1)
sound_add_included("__ONLINE_sndSaved.wav", 0, 1)
globalvar @sndChatbox, @sndSaved;
@sndChatbox = "__ONLINE_sndChatbox"
@sndSaved = "__ONLINE_sndSaved"
#endif

#if GM80
chnFont = fw_add_font('Microsoft Yahei', 9, false, false, false);
fw_set_font_offset(chnFont, -1, -4);
fw_draw_set_font(chnFont);
#endif
